
#include <EtherCard.h>
#include <Adafruit_ST7735.h>
// ethernet interface mac address, must be unique on the LAN
byte cdp_mac[] = {
  0x01, 0x00, 0x0c, 0xcc, 0xcc, 0xcc};
byte mymac[] = {
  0x00,0x01,0x02,0x03,0x04,0x05};

#define MAC_LENGTH 6
byte Ethernet::buffer[500];    

int Device = 0;
int Port = 0;
int SWver = 0;
int Model = 0;
int CrntItem =0;
int ValidPacket = 0;
String LCD_data[6];
String Names[6] ={   
  "Name:", "MAC:" ,"Port:", "Model:","VLAN:","IP:"};
int Changed=0;

String oldport;
String oldmac;
String oldvlan;

#include <Adafruit_GFX.h>    // Core graphics library
#include <Adafruit_ST7735.h> // Hardware-specific library
#include <SPI.h>

//Use these pins for the shield!
#define sclk 13
#define mosi 11
#define cs   4
#define dc   8
#define rst  -1  // you can also connect this to the Arduino reset

#if defined(__SAM3X8E__)
#undef __FlashStringHelper::F(string_literal)
#define F(string_literal) string_literal
#endif

// Option 1: use any pins but a little slower
Adafruit_ST7735 tft = Adafruit_ST7735(cs, dc, rst);

//Print &out = tft;

void setup()
{
  //  tft.fillScreen(ST7735_BLACK);
  pinMode(13, OUTPUT); 
  Serial.begin(9600);
  Serial.print("hello!");
  tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab
  Serial.println("init");

  tft.fillScreen(ST7735_BLACK);

  tft.setTextWrap(false);
  tft.setRotation(1);
  tft.setCursor(0, 0);
  testdrawtext("Default Interval is 60secs!\n", ST7735_RED);
  // testdrawtext("DHCP:", ST7735_BLUE);

  ether.begin(sizeof Ethernet::buffer, mymac,10);

  if (!ether.dhcpSetup())
  {
    testdrawtext("DHCP failed.\n", ST7735_RED);
  }
  else
  {

    testdrawtext("DHCP IP:",ST7735_GREEN);
    for(unsigned int j=0; j<4; ++j) {
      testdrawtext(String(ether.myip[j]),ST7735_WHITE); 
      if (j<3){
        testdrawtext(".",ST7735_WHITE); 
      }
    }
    testdrawtext("\n",ST7735_WHITE); 
  }
  delay(1000);
  ENC28J60::enablePromiscuous();

  // ether.printIp("GW: ", ether.gwip);

}
void loop()
{

  if (ValidPacket !=0){
    if ((oldmac != LCD_data[1]) || (oldport != LCD_data[2]) || (oldvlan != LCD_data[4])){
      drawscreen();

    }
    oldmac = LCD_data[1];
    oldport = LCD_data[2];
    oldvlan = LCD_data[4];
    ValidPacket=0;
  }




  int plen = ether.packetReceive();
  if( plen > 0 ) {



    if(byte_array_contains(Ethernet::buffer, 0, cdp_mac, sizeof(cdp_mac))) {

      ValidPacket=1;



      byte* macFrom = Ethernet::buffer+sizeof(cdp_mac);
      //print_mac(macFrom, 0,sizeof(cdp_mac));
      // Serial.print("Time Taken: ");
      //Serial.print(min); Serial.print(':');
      //if(sec < 10) Serial.print('0');
      //Serial.print(sec);
      //Serial.println();

      // Serial.print("Packet From:");

      print_mac(macFrom, 0, 6);



      int cdpTtl = Ethernet::buffer[23];
      Serial.print("TTL: ");
      Serial.println(cdpTtl);
      //      Ethernet::bufferIndex=26;



      int cdpDataIndex = 26;


      while(cdpDataIndex < plen) { // read all remaining TLV fields
        /*  unsigned int cdpFieldType = (Ethernet::buffer[26] << 8) | Ethernet::buffer[27];
         cdpDataIndex+=2;
         unsigned int cdpFieldLength = (Ethernet::buffer[28] << 8) | Ethernet::buffer[29];
         cdpDataIndex+=2;
         cdpFieldLength -= 4;
         */
        unsigned int cdpFieldType = (Ethernet::buffer[cdpDataIndex] << 8) | Ethernet::buffer[cdpDataIndex+1];
        cdpDataIndex+=2;
        unsigned int cdpFieldLength = (Ethernet::buffer[cdpDataIndex] << 8) | Ethernet::buffer[cdpDataIndex+1];
        cdpDataIndex+=2;
        cdpFieldLength -= 4;
        //Serial.print(cdpFieldType,HEX);
        switch(cdpFieldType) {
        case 0x0001:
          Device =1;
          handleCdpAsciiField(F("Device: "), Ethernet::buffer, cdpDataIndex, cdpFieldLength);
          Device =0;
          break;
        case 0x0002:
          handleCdpAddresses(Ethernet::buffer, cdpDataIndex, cdpFieldLength);
          break;
        case 0x0003:
          Port = 1;
          handleCdpAsciiField(F("Port: "), Ethernet::buffer, cdpDataIndex, cdpFieldLength);
          Port = 0;
          break;
          //    case 0x0004:
          //     handleCdpCapabilities(Ethernet::buffer, cdpDataIndex, cdpFieldLength);
          //    break;
          /*   case 0x0005:
           SWver = 1;
           handleCdpAsciiField(F("SW ver: "), Ethernet::buffer, cdpDataIndex, cdpFieldLength);
           SWver = 0;
           break;
           */
        case 0x0006:
          Model = 1;
          handleCdpAsciiField(F("Model: "), Ethernet::buffer, cdpDataIndex, cdpFieldLength);
          Model = 0;
          break;
        case 0x000a:
          handleCdpNumField(F("VLAN: "), Ethernet::buffer, cdpDataIndex, cdpFieldLength);
          break;
          //  case 0x000b:
          //    handleCdpDuplex(Ethernet::buffer, cdpDataIndex, cdpFieldLength);
          //     break;
        }
        cdpDataIndex += cdpFieldLength;
      }
      Serial.println("--------END-------");



    }
  }



}
void handleCdpAsciiField(const __FlashStringHelper * title,  byte a[], unsigned int offset, unsigned int length) {
  Serial.print(title);

  print_str(a, offset, length);
  Serial.println();
}

void handleCdpNumField(const __FlashStringHelper * title, const byte a[], unsigned int offset, unsigned int length) {
  unsigned long num = 0;
  for(unsigned int i=0; i<length; ++i) {
    num <<= 8;
    num += a[offset + i];
  }

  Serial.print(title);
  Serial.print(num, DEC);
  //lcd.setCursor(0,1);
  // lcd.print();
  //lcd.setCursor(5,1);
  //lcd.print(num);
  Serial.println();
  LCD_data[4]="" + String(num,DEC);

}

void handleCdpAddresses(const byte a[], unsigned int offset, unsigned int length) {
  Serial.print(F("Addresses: "));

  unsigned long numOfAddrs = (a[offset] << 24) | (a[offset+1] << 16) | (a[offset+2] << 8) | a[offset+3];
  offset += 4;

  for(unsigned long i=0; i<numOfAddrs; ++i) {
    unsigned int protoType = a[offset++];
    unsigned int protoLength = a[offset++];
    byte proto[8];
    for(unsigned int j=0; j<protoLength; ++j) {
      proto[j] = a[offset++];
    }
    unsigned int addressLength = (a[offset] << 8) | a[offset+1];

    offset += 2;
    byte address[4];
    if(addressLength != 4) Serial.println(F("Expecting address length: 4"));

    LCD_data[5]="";
    for(unsigned int j=0; j<addressLength; ++j) {
      address[j] = a[offset++];

      LCD_data[5]=LCD_data[5] + address[j] ;
      if (j<3){
        LCD_data[5]=LCD_data[5] + ".";
      }
      Serial.print(address[j] + ".");
    }
    //  uint8_t ipaddr[4]; 
    //ether.parseIp(ipaddr, LCD_data[5]);


  }

}
/*
void handleCdpDuplex(const byte a[], unsigned int offset, unsigned int length) {
 Serial.print(F("Duplex: "));
 if(a[offset]) {
 Serial.println(F("Full"));
 } 
 else {
 Serial.println(F("Half"));
 }
 }
 */
void print_str(byte a[], unsigned int offset, unsigned int length) {
  int j =0;
  char temp [40] ;


  for(unsigned int i=offset; i<offset+40; ++i ,++j) {
    if (Device!=0){

      temp[j]=a[i];
      //lcd.print(temp);
      LCD_data[0]=temp;
    }

    if (Port!=0){
      temp[j]=a[i];
      //lcd.print(temp);
      LCD_data[2]=temp;
      ;
    }

    if (Model!=0){
      temp[j]=a[i];
      //lcd.print(temp);
      LCD_data[3]=temp;
      ;
    }

    Serial.write(a[i]);
    //    return a[i];
  }


}




String print_ip(const byte a[], unsigned int offset, unsigned int length) {
  String ip;
  for(unsigned int i=offset; i<offset+length; ++i) {
    //    if(i>offset) Serial.print('.');
    //   Serial.print(a[i], DEC);
    if(i>offset) ip = ip + '.';
    ip = ip + String (a[i]);
  }
  int iplentgh;
  ip=ip.substring(ip.length()-1)='\0';


  Serial.print(ip);
  return ip;
}

String print_mac(const byte a[], unsigned int offset, unsigned int length) {
  String Mac;
  char temp [40];
  LCD_data[1] = "";
  for(unsigned int i=offset; i<offset+length; ++i) {
    // if(i>offset) Serial.print(':');
    //  if(a[i] < 0x10) Serial.print('0');
    // Serial.print(a[i], HEX);

    if(i>offset){
      //  LCD_data[1] = LCD_data[1] + Mac + ':';
      Mac = Mac + ':';
    }
    if(a[i] < 0x10) {
      Mac= Mac + '0';
      //    LCD_data[1] = LCD_data[1] + Mac + '0';
    }
    Mac= Mac + String (a[i],HEX);



  }
  LCD_data[1]=LCD_data[1]  + Mac;
  Serial.println(Mac);

  return Mac;
}

bool byte_array_contains(const byte a[], unsigned int offset, const byte b[], unsigned int length) {

  for(unsigned int i=offset, j=0; j<length; ++i, ++j) {
    if(a[i] != b[j]) {

      return false;
    }

  }

  return true;
}



void print_byte(byte a[],int psize) {

  for(unsigned int i=0; i<psize; ++i) {

    Serial.print(a[i],HEX);

  }



}

char val2dec(byte b) {
  switch(b) {
  case 0: 
    return '0';
  case 1: 
    return '1';
  case 2: 
    return '2';
  case 3: 
    return '3';
  case 4: 
    return '4';
  case 5: 
    return '5';
  case 6: 
    return '6';
  case 7: 
    return '7';
  case 8: 
    return '8';
  case 9: 
    return '9';
  }
}


void drawvalues(char *text, uint16_t color) {

  tft.setTextColor(color);
  tft.setTextWrap(true);
  tft.setRotation(1);
  ;
}
void testdrawtext(String text, uint16_t color) {

  tft.setTextColor(color);
  //tft.setTextWrap(true);
  //  tft.setRotation(1);
  tft.print(text);
}
int testconnect(String ipaddr, int port){

  // if (client.connect(ipaddr, port)) {
  //   return 1;
  // } 
  //  else {
  //   // if you didn't get a connection to the server:
  //   return 0 ;

  // }
}

void drawscreen (){
  tft.fillScreen(ST7735_BLACK);

  tft.setTextWrap(false);
  tft.setRotation(1);
  tft.setCursor(0, 0);
  testdrawtext("Default Interval is 60secs!\n", ST7735_RED);
  if (String(ether.myip[1])==""){
    testdrawtext("DHCP failed.\n", ST7735_RED);
  }
  else
  {
    testdrawtext("DHCP IP:",ST7735_GREEN);
    for(unsigned int j=0; j<4; ++j) {
      testdrawtext(String(ether.myip[j]),ST7735_WHITE); 
      if (j<3){
        testdrawtext(".",ST7735_WHITE); 
      }
    }
    testdrawtext("\n",ST7735_WHITE); 
  }
  delay(1000); 
  for(unsigned int i=0; i<6; ++i) {




    tft.setCursor(0, i*10+28);
    testdrawtext(Names[i],ST7735_GREEN);

    testdrawtext(LCD_data[i] + "\n",ST7735_WHITE);

  }
}



