// UTouch_ButtonTest (C)2010-2014 Henning Karlsen
// web: http://www.henningkarlsen.com/electronics
//
// This program is a quick demo of how create and use buttons.
//
// It is assumed that the display module is connected to an
// appropriate shield or that you know how to change the pin 
// numbers in the setup.
//


#include "SPI.h"
#include "Adafruit_GFX.h"
#include "Adafruit_ILI9341.h"

#include <UTouch.h>
#define TFT_CS 10
#define TFT_DC 9
//Using Adafruit library (modified, faster version) instead:
Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC);

// Initialize touchscreen
// ----------------------
// Set the pins to the correct ones for your development board
// -----------------------------------------------------------
// Standard Arduino Uno/2009 Shield            : 15,10,14, 9, 8
// Standard Arduino Mega/Due shield            :  6, 5, 4, 3, 2
// CTE TFT LCD/SD Shield for Arduino Due       :  6, 5, 4, 3, 2
// Teensy 3.x TFT Test Board                   : 26,31,27,28,29
// ElecHouse TFT LCD/SD Shield for Arduino Due : 25,26,27,29,30
//
//      myTouch(SCK, CS,  DIN, DOUT, IRQ)
//      myTouch(SCK, CS, MOSI, MISO, IRQ)
UTouch  myTouch( 6, 5, 4, 3, 2);

// Declare which fonts we will be using
//extern uint8_t BigFont[];

int x, y;
char stCurrent[20]="";
int stCurrentLen=0;
char stLast[20]="";

#include <SoftwareSerial.h>
SoftwareSerial dbg(8, 7); // using pin 7, 8 for software dbg
#define SSID  "<SSID>"   // change this to match your WiFi SSID
#define PASS  "<SSID PASSWORD>"  // change this to match your WiFi password
#define WIFIBRIDGE "<WIFI BRIDGE PASSWORD>" //wifi bridge ip address.



#define BUFFER_SIZE 128
char buffer[BUFFER_SIZE];



byte lightson[] = {0x22,0x00,0x55};
byte lightsoff[] = {0x21,0x00,0x55};
byte COLORLEDALLOFF[] = {0x41,0x00,0x55};
byte COLORLEDALLON[] = {0x42,0x00,0x55};
byte DISCOSPEEDSLOWER[] = {0x43,0x00,0x55};
byte DISCOSPEEDFASTER[] = {0x44,0x00,0x55};
byte GROUP1ALLON[] = {0x45,0x00,0x55}; //(SYNC/PAIR RGB+W Bulb within 2 seconds of Wall Switch Power being turned ON)
byte GROUP1ALLOFF[] = {0x46,0x00,0x55};
byte GROUP2ALLON[] = {0x47,0x00,0x55}; //(SYNC/PAIR RGB+W Bulb within 2 seconds of Wall Switch Power being turned ON)
byte GROUP2ALLOFF[] = {0x48,0x00,0x55};
byte GROUP3ALLON[] = {0x49,0x00,0x55}; //(SYNC/PAIR RGB+W Bulb within 2 seconds of Wall Switch Power being turned ON)
byte GROUP3ALLOFF[] = {0x4A,0x00,0x55};
byte GROUP4ALLON[] = {0x4B,0x00,0x55}; //(SYNC/PAIR RGB+W Bulb within 2 seconds of Wall Switch Power being turned ON)
byte GROUP4ALLOFF[] = {0x4C,0x00,0x55};
byte DISCOMODE[] = {0x4D,0x00,0x55};
byte WHITEMODE[] = {0xC2,0x00,0x55};

/*SET COLOR TO WHITE (GROUP ALL) 0x42 100ms followed by: 0xC2
 SET COLOR TO WHITE (GROUP 1) 0x45 100ms followed by: 0xC5
 SET COLOR TO WHITE (GROUP 2) 0x47 100ms followed by: 0xC7
 SET COLOR TO WHITE (GROUP 3) 0x49 100ms followed by: 0xC9
 SET COLOR TO WHITE (GROUP 4) 0x4B 100ms followed by: 0xCB
 */
/*************************
 **   Custom functions   **
 *************************/

void drawButtons()
{

  tft.setTextSize(2);
  // Draw the upper row of buttons
  for (x=0; x<4; x++)
  {
    //tft.setColor(0, 0, 255);
    if (x==0){tft.fillRoundRect (10+(x*75), 10, 75, 60, 5, ILI9341_BLUE);}
    if (x==1){tft.fillRoundRect (10+(x*75), 10, 75, 60, 5, ILI9341_RED);}
    if (x==2){tft.fillRoundRect (10+(x*75), 10, 75, 60, 5, ILI9341_BLUE);}
    if (x==3){tft.fillRoundRect (10+(x*75), 10, 75, 60, 5, ILI9341_BLUE);}
  //  tft.fillRoundRect (10+(x*75), 10, 75, 60, 5, ILI9341_BLUE);

    tft.drawRoundRect (10+(x*75), 10, 75, 60, 5, ILI9341_WHITE);
tft.setTextColor(ILI9341_WHITE);
    tft.setCursor (15+(x*75), 27);
    // tft.print(x+1);
    if (x+1==1)  {
      tft.print ("  ON");
    }
    if (x+1==2)  {
      tft.print ("  OFF");
    }
    if (x+1==3)  {
      tft.print (" MODE");
    }
    if (x+1==4)  {
      tft.print ("WHITE");
    }
    /*}
     else
     {
     tft.print(x+1);
     }
     */
     tft.setTextColor(ILI9341_WHITE);
  }
  // Draw the center row of buttons
  for (x=0; x<4; x++)
  {
    //tft.setColor(0, 0, 255);
    tft.fillRoundRect (10+(x*75), 70, 75, 60, 5, ILI9341_BLUE);
    //tft.setColor(255, 255, 255);
    tft.drawRoundRect (10+(x*75), 70, 75, 60, 5, ILI9341_WHITE);
    if (x<4){
      tft.setCursor (15+(x*75), 87);
      //tft.print(x+6);}
      if (x+6==6)  {
        tft.print ("PATIO");
      }
      if (x+6==7)  {
        tft.print ("SHED*");
      }
      if (x+6==8)  {
        tft.print ("");
      }
      if (x+6==9)  {
        tft.print ("");
      }
    }
  }

  // tft.setCursor(267, 87);
  // tft.print("0");
/*
  // Draw the lower row of buttons
  tft.setCursor(0,0);
  //tft.setColor(0, 0, 255);
  tft.fillRoundRect (10, 130, 150, 60, 5, ILI9341_BLUE);
  //tft.setColor(255, 255, 255);
  tft.drawRoundRect (10, 130, 150, 60, 5, ILI9341_WHITE);
  tft.setCursor(40, 147);
  tft.print("Clear");
  //tft.setColor(0, 0, 255);
  tft.setCursor(0,0);
  tft.fillRoundRect (160, 130, 150, 60, 5, ILI9341_BLUE);
  //tft.setColor(255, 255, 255);
  tft.drawRoundRect (160, 130, 150, 60, 5, ILI9341_WHITE);

  tft.setCursor(190, 147);
  tft.print("Enter");
  //tft.setBackColor (0, 0, 0);
  */
}

void updateStr(int val)
{/*
  if (stCurrentLen<20)
  {
    stCurrent[stCurrentLen]=val;
    stCurrent[stCurrentLen+1]='\0';
    stCurrentLen++;
    tft.setTextColor(ILI9341_WHITE, ILI9341_BLACK);
    tft.setCursor(0, 224);
    tft.print(stCurrent);
  }
  else
  {
    tft.setTextColor(ILI9341_WHITE, ILI9341_BLACK);
    tft.setCursor(50, 192);
    tft.print("BUFFER FULL!");
    delay(500);
    tft.setCursor(50, 192);
    tft.print("            ");
    delay(500);
    tft.setCursor(50, 192);
    tft.print("BUFFER FULL!");
    delay(500);
    tft.setCursor(50, 192);
    tft.print("            ");
    //tft.setColor(0, 255, 0);
  }*/
}

// Draw a red frame while a button is touched
void waitForIt(int x1, int y1, int x2, int y2)
{
  //tft.setColor(255, 0, 0);
  tft.drawRoundRect (x1, y1, x2, y2, 5, ILI9341_RED);
  while (myTouch.dataAvailable())
    myTouch.read();
  //tft.setColor(255, 255, 255);
  tft.drawRoundRect (x1, y1, x2, y2, 5, ILI9341_WHITE);
}

/*************************
 **  Required functions  **
 *************************/

void setup()
{
  // Initial setup
  dbg.begin(9600);
  tft.begin();
  // init done
  tft.setRotation(1);
  tft.fillScreen(ILI9341_BLACK);//clear tft
  tft.setTextSize(1);
  tft.setCursor(25, 150);
  tft.print("LOADING");
  myTouch.InitTouch();
  myTouch.setPrecision(PREC_MEDIUM);

  //tft.setFont(BigFont);
  //tft.setBackColor(0, 0, 255);
  drawButtons();  
  StartWIFI();
  tft.setTextColor(ILI9341_WHITE, ILI9341_BLACK);
   tft.setTextSize(1);
  tft.setCursor(25, 150);
  tft.print("DONE       ");
}

void loop()
{
  while (true)
  {
    if (myTouch.dataAvailable())
    {
      myTouch.read();
      x=myTouch.getX();
      y=myTouch.getY();

      if ((y>=10) && (y<=60))  // Upper row
      {
        if ((x>=10) && (x<=85))  // Button: ON
        {

          waitForIt(10, 10, 75, 60);
          sendval(COLORLEDALLON);
          sendval(WHITEMODE);
          sendval(lightson);
        }
        if ((x>=85) && (x<=160))  // Button: OFF
        {
          waitForIt(85, 10, 75, 60);
          sendval(COLORLEDALLOFF);
          sendval(lightsoff);
          
        }
        if ((x>=160) && (x<=235))  // Button: MODE
        {
          waitForIt(160, 10, 75, 60);
             sendval(DISCOMODE);
          
        
        }
        if ((x>=235) && (x<=310))  // Button: WHITE
        {
          waitForIt(235, 10, 75, 60);
          //updateStr('4');
           sendval(COLORLEDALLON);
          sendval(WHITEMODE);
        }

      }

      if ((y>=70) && (y<=120))  // Center row
      {
        if ((x>=10) && (x<=85))  // Button: SPOT
        {
          waitForIt(10, 70, 75, 60);
          //updateStr('6');
        sendval(lightson);
        }
        if ((x>=85) && (x<=160))  // Button: Patio
        {
          waitForIt(85, 70, 75, 60);
          //updateStr('7');
         sendval(GROUP1ALLON);
          sendval(GROUP2ALLON);
        }
        if ((x>=160) && (x<=235))  // Button: SHED
        {
          waitForIt(160, 70, 75, 60);
         // sendval(COLORLEDALLON);
         // sendval(WHITEMODE);
        }
        if ((x>=235) && (x<=310))  // Button: 9
        {
          waitForIt(235, 70, 75, 60);
          //updateStr('9');
        }

      }

   /*   if ((y>=130) && (y<=180))  // Upper row
      {
        if ((x>=10) && (x<=150))  // Button: Clear
        {
          waitForIt(10, 130, 150, 60);
          stCurrent[0]='\0';
          stCurrentLen=0;
          //tft.setColor(0, 0, 0);
          tft.fillRect(0, 208, 319, 31, ILI9341_BLACK);
        }
        if ((x>=160) && (x<=300))  // Button: Enter
        {
          waitForIt(160, 130, 150, 60);
          if (stCurrentLen>0)
          {
            for (x=0; x<stCurrentLen+1; x++)
            {
              stLast[x]=stCurrent[x];
            }
            stCurrent[0]='\0';
            stCurrentLen=0;
            //tft.setColor(0, 0, 0);
            tft.fillRect(0, 208, 319, 31, ILI9341_BLACK);
            //tft.setColor(0, 255, 0);
            tft.setCursor( 0, 208);
            tft.print(stLast);
          }
          else
          {
            tft.setTextColor(ILI9341_RED,ILI9341_BLACK);
            tft.setCursor(50, 192);
            tft.print("BUFFER FULL!");
            delay(500);
            tft.setCursor(50, 192);
            tft.print("            ");
            delay(500);
            tft.setCursor(50, 192);
            tft.print("BUFFER FULL!");
            delay(500);
            tft.setCursor(50, 192);
            tft.print("            ");

          }
        }
      }*/
    }
  }
}
  void StartWIFI(){
    dbg.println("AT+CWMODE=1");
    delay(500); 

    // reset WiFi module
    dbg.println("AT+RST");
    delay(3000);

    
    dbg.print("AT+CWJAP=\"");
    dbg.print(SSID);
    dbg.print("\",\"");
    dbg.print(PASS);
    dbg.println("\"");
    delay(6000);

    dbg.println("AT+CIPMUX=0");
   
    delay(1000);

  }
  void sendval (byte val[]){
  tft.setTextColor(ILI9341_WHITE, ILI9341_BLACK);
   tft.setTextSize(1);
  tft.setCursor(25, 150);
  tft.print("SENDING       ");
    dbg.print("AT+CIPSTART=\"UDP\",\"");
    dbg.print(WIFIBRIDGE);
    dbg.println("\",8899");
    delay(500);
    dbg.println("AT+CIPSEND=3");
    delay(2000);
    
    dbg.write(val,3);
    delay(1000);
  
    dbg.println("\r\n");
  tft.setTextColor(ILI9341_WHITE, ILI9341_BLACK);
   tft.setTextSize(1);
  tft.setCursor(25, 150);
  tft.print("DONE        ");

  //  delay(2000);
   // dbg.println("AT+CIPCLOSE");
  }



