// include the library code:
#include <LiquidCrystal.h>

// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(8, 9, 4, 5, 6, 7);

// setup timer
int lasttime = 0;
unsigned long Watch, _micro, time = micros();
unsigned int Clock = 0, R_clock;
boolean Reset = false, Stop = false, Paused = false;
volatile boolean timeFlag = false;
//end of timer setup

//relay setup
#define RELAY1  1
#define BUZZER  0
#include "max6675.h"

int temp1 = 100;
int temp2 = 100;
int tempCount = 0;
int waitTime = 0;

int forc = 0;
int thermoDO1 = 2;
int thermoCS1 = 3;
int thermoCLK1 = 13;

int thermoDO2 = 11;
int thermoCS2 = 12;
int thermoCLK2 = 13;

int timerset = 0;
int temp1set = 100;
int temp2set = 100;
int menuselected = 0;

int buzzcount = 0;

MAX6675 thermocouple(thermoCLK1, thermoCS1, thermoDO1);
MAX6675 thermocouple2(thermoCLK2, thermoCS2, thermoDO2);
//MAX6675 thermocouple2(thermoCLK, 2, 3);
long previousMillis = 0;        // will store last time LED was updated
long PrevTempMillis = 0;
// the follow variables is a long because the time, measured in miliseconds,
// will quickly become a bigger number than can be stored in an int.
long interval = 5000;           // interval at which to blink (milliseconds)
long TempInterval = 1000;

//States for the menu.
int currentMenuItem = 0;
int lastState = 0;
int currentTemp = 0;
int runningtime = 1;

void setup() {
  pinMode(RELAY1, OUTPUT);
  pinMode(BUZZER, OUTPUT);
  pinMode(12, OUTPUT);
  pinMode(11, INPUT);
  // set up the LCD's number of columns and rows:
  lcd.begin(16, 2);
  // Print a message to the LCD.
  lcd.setCursor(0, 0);
  lcd.print("Loading...");
  //  lcd.setCursor(0,1);
  //  lcd.print("Timer: ");

  //setup timer
  SetTimer(0, 0, 1); // 10 seconds
  StartTimer();
  //end timer

  digitalWrite(BUZZER, HIGH);
  delay(500);
  digitalWrite(RELAY1, HIGH);
  digitalWrite(BUZZER, LOW);
}

void loop() {
  CountDownTimer(); // run the timer
  printtemps();
  mainMenu();
  if (currentMenuItem == 0) {
    showtime();
  }
  delay(100);
  checktemps();
}

void checktemps () {
  unsigned long TempMillis = millis();
  if (TempMillis - PrevTempMillis > TempInterval) {
    PrevTempMillis = TempMillis;

    if (waitTime > 30) {
      if (temp1 - currentTemp < 10 && temp1 - currentTemp > 0 ) {
        digitalWrite(RELAY1, LOW);
        tempCount = tempCount + 5;
      }
      if (temp1 - currentTemp > 10 || currentTemp - temp1 > 10) {
        digitalWrite(RELAY1, LOW);
        tempCount = tempCount + 1;
        if (buzzcount == 600000 && runningtime == 1) {
          digitalWrite(BUZZER, HIGH);
          delay(300);
          digitalWrite(BUZZER, LOW);
          delay(300);
          digitalWrite(BUZZER, HIGH);
          delay(300);
          digitalWrite(BUZZER, LOW);
          buzzcount = buzzcount = 0;
        }
      }
      if (tempCount > 15) {
        tempCount = 0;
        waitTime = 0;
        digitalWrite(RELAY1, HIGH);
      }
    }
    buzzcount = buzzcount + 1;
    waitTime = waitTime + 1;
    digitalWrite(BUZZER, LOW);
  }
}



void showtime() {
  //if (lasttime != Clock){
  clearmenu();
  lcd.setCursor(0, 1);
  lcd.print("Timer: ");


  lcd.print(ShowHours());
  lcd.print(":");
  lcd.print(ShowMinutes());
  lcd.print(":");
  lcd.print(ShowSeconds());
  if (currentMenuItem == 3) {
    lcd.print ("*");
  }
  if (currentMenuItem != 3) {
    lcd.print ("  ");
  }
  
  if (ShowHours() == 0 &&  ShowMinutes() == 0 && ShowSeconds() == 0 && runningtime == 1) {
    digitalWrite(BUZZER, HIGH);
    delay(100);
    digitalWrite(BUZZER, LOW);
    delay(300);
    digitalWrite(BUZZER, HIGH);
    delay(100);
    digitalWrite(BUZZER, LOW);
    runningtime = 0;
  }
  if (ShowHours() > 0 ||  ShowMinutes() > 0 || ShowSeconds() > 0) {
    runningtime = 1;
  }


  lasttime = Clock;

}
void clearmenu() {
  lcd.setCursor(0, 1);
  lcd.print ("                ");
}
void showtemp(int num) {
  clearmenu();
  lcd.setCursor(0, 1);

  lcd.print ("Temp");
  lcd.print(num);
  lcd.print (": ");
  if (num == 1) {
    lcd.print(temp1);
  }
  if (num == 2) {
    lcd.print(temp2);

  }
}

void printtemps() {
  unsigned long currentMillis = millis();
  if (currentMillis - previousMillis > interval) {
    // save the last time you blinked the LED
    previousMillis = currentMillis;

    lcd.setCursor(0, 0);
    lcd.print("                ");
    lcd.setCursor(0, 0);
    if (forc == 0) {
      lcd.print("T1:");
      if (thermocouple.readCelsius() > 0) {
        lcd.print(round(thermocouple.readCelsius()));
        currentTemp = thermocouple.readCelsius();
        //      lcd.print((char)223);
      }
      lcd.print("C");

      lcd.print(" T2:");
      if (thermocouple2.readCelsius() > 0) {
        lcd.print(round(thermocouple2.readCelsius()));
        //      lcd.print((char)223);
      }
      lcd.print("C");

    }
    if (forc == 1) {
      lcd.print("T1:");
      if (thermocouple.readFahrenheit() > 0) {
        lcd.print(round(thermocouple.readFahrenheit()));
        currentTemp = thermocouple.readFahrenheit();
        //      lcd.print((char)223);
      }
      lcd.print("F");


      lcd.print(" T2:");
      if (thermocouple2.readFahrenheit() > 0) {
        lcd.print(round(thermocouple2.readFahrenheit()));
        //      lcd.print((char)223);
      }
      lcd.print("F");

    }
  }
}

void mainMenu() {
  //State = 0 every loop cycle.
  int state = 0;
  //Refresh the button pressed.
  int x = analogRead (0);
  //Set the Row 0, Col 0 position.
  lcd.setCursor(0, 0);

  //Check analog values from LCD Keypad Shield
  if (x < 100) {
    //Right
    switch (currentMenuItem) {
      case 1:
        temp1 = temp1 + 5;
        showtemp(1);
        break;

      case 2:
        temp2 = temp2 + 5;
        showtemp(2);
        break;

      case 3:
        SetTimer(Clock + (10 * 60));
        showtime();

        delay(400);
        break;

      case 4:
        forc = 1;
        showtemptype();

        break;
    }
  }
  else if (x < 200) {
    //Up
    state = 1;
  }
  else if (x < 400) {
    //Down
    state = 2;
  }
  else if (x < 600) {
    switch (currentMenuItem) {
      case 1:
        temp1 = temp1 - 5;
        showtemp(1);
        break;

      case 2:
        temp2 = temp2 - 5;
        showtemp(2);
        break;

      case 3:
        SetTimer(Clock - (10 * 60));
        showtime();
        delay(200);
        break;

      case 4:
        forc = 0;
        showtemptype();
        break;
    }
  }
  else if (x < 800) {
    //Select
    state = 3;
  }

  //If we are out of bounds on th menu then reset it.
  if (currentMenuItem < 0) {
    currentMenuItem = 0;
  }
  if (currentMenuItem > 4) {
    currentMenuItem = 4;
  }



  //If we have changed Index, saves re-draws.
  if (state != lastState) {
    if (state == 1) {
      //If Up
      currentMenuItem = currentMenuItem - 1;
      displayMenu(currentMenuItem);
    }
    else if (state == 2) {
      //If Down
      currentMenuItem = currentMenuItem + 1;
      displayMenu(currentMenuItem);
    }
    else if (state == 3) {
      //If Selected
      selectMenu(currentMenuItem);
    }
    //Save the last State to compare.
    lastState = state;
  }

  //Small delay
  delay(5);
}

//Display Menu Option based on Index.
void displayMenu(int x) {
  clearPrintTitle();
  lcd.setCursor(0, 1);
  switch (x) {

    case 1:
      showtemp(1);
      break;

    case 2:
      showtemp(2);
      break;

    case 3:
      showtime();
      break;

    case 4:
      showtemptype();
      break;
  }
}

void showtemptype() {
  clearPrintTitle();
  lcd.setCursor(0, 1);
  lcd.print ("Temp:");
  if (forc == 0) {
    lcd.print((char)223);
    lcd.print("c* or ");
    lcd.print((char)223);
    lcd.print("F");
  }
  if (forc == 1) {
    lcd.print((char)223);
    lcd.print("c  or ");
    lcd.print((char)223);
    lcd.print("F*");
  }
}

//Print a basic header on Row 1.
void clearPrintTitle() {
  lcd.setCursor(0, 1);
  lcd.print ("                ");
}

//Show the selection on Screen.
void selectMenu(int x) {
  clearPrintTitle();
  /*  lcd.setCursor(0, 1);
    switch (x) {
      case 1:

        lcd.print ("Temp 1 Set");
        //Call the function that belongs to Option 1
        break;
      case 2:
        lcd.print ("Temp 2 Set");
        //Call the function that belongs to Option 2
        break;
      case 3:
        lcd.print ("Timer Set");
        //Call the function that belongs to Option 3

        break;
      case 4:
        lcd.print ("Temp Type Set");
        //Call the function that belongs to Option 4
        break;
    }
    delay(2000);
   */
  showtime();
  currentMenuItem = 0;
}


//timer modules

void showtimer() {
  lcd.setCursor(0, 1);

  // this prevents the time from being constantly shown.
  if (TimeHasChanged() )
  {
    lcd.print(ShowHours());
    lcd.print(":");
    lcd.print(ShowMinutes());
    lcd.print(":");

    // This DOES NOT format the time to 0:0x when seconds is less than 10.
    // if you need to format the time to standard format, use the sprintf() function.
  }
}

boolean CountDownTimer()
{
  static unsigned long duration = 1000000; // 1 second
  timeFlag = false;

  if (!Stop && !Paused) // if not Stopped or Paused, run timer
  {
    // check the time difference and see if 1 second has elapsed
    if ((_micro = micros()) - time > duration )
    {
      Clock--;
      timeFlag = true;

      if (Clock == 0) // check to see if the clock is 0
        Stop = true; // If so, stop the timer

      // check to see if micros() has rolled over, if not,
      // then increment "time" by duration
      _micro < time ? time = _micro : time += duration;
    }
  }
  return !Stop; // return the state of the timer
}

void ResetTimer()
{
  SetTimer(R_clock);
  Stop = false;
}

void StartTimer()
{
  Watch = micros(); // get the initial microseconds at the start of the timer
  Stop = false;
  Paused = false;
}

void StopTimer()
{
  Stop = true;
}

void StopTimerAt(unsigned int hours, unsigned int minutes, unsigned int seconds)
{
  if (TimeCheck(hours, minutes, seconds) )
    Stop = true;
}

void PauseTimer()
{
  Paused = true;
}

void ResumeTimer() // You can resume the timer if you ever stop it.
{
  Paused = false;
}

void SetTimer(unsigned int hours, unsigned int minutes, unsigned int seconds)
{
  // This handles invalid time overflow ie 1(H), 0(M), 120(S) -> 1, 2, 0
  unsigned int _S = (seconds / 60), _M = (minutes / 60);
  if (_S) minutes += _S;
  if (_M) hours += _M;

  Clock = (hours * 3600) + (minutes * 60) + (seconds % 60);
  R_clock = Clock;
  Stop = false;
}

void SetTimer(unsigned int seconds)
{
  // StartTimer(seconds / 3600, (seconds / 3600) / 60, seconds % 60);
  Clock = seconds;
  R_clock = Clock;
  Stop = false;
}

int ShowHours()
{
  return Clock / 3600;
}

int ShowMinutes()
{
  return (Clock / 60) % 60;
}

int ShowSeconds()
{
  return Clock % 60;
}

unsigned long ShowMilliSeconds()
{
  return (_micro - Watch) / 1000.0;
}

unsigned long ShowMicroSeconds()
{
  return _micro - Watch;
}

boolean TimeHasChanged()
{
  return timeFlag;
}

// output true if timer equals requested time
boolean TimeCheck(unsigned int hours, unsigned int minutes, unsigned int seconds)
{
  return (hours == ShowHours() && minutes == ShowMinutes() && seconds == ShowSeconds());
}
//end of timer modules
